/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

@SerialClass
public class GolemConfigCapability
implements ICapabilitySerializable<CompoundTag> {
    public final ServerLevel w;
    public final GolemConfigStorage handler;
    public final LazyOptional<GolemConfigStorage> lo;

    public GolemConfigCapability(ServerLevel level) {
        this.w = level;
        this.handler = new GolemConfigStorage((Level)level);
        this.lo = LazyOptional.of(() -> this.handler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
        if (capability == GolemConfigStorage.CAPABILITY) {
            return this.lo.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return TagCodec.toTag((CompoundTag)new CompoundTag(), this.lo.resolve().get());
    }

    public void deserializeNBT(CompoundTag tag) {
        Wrappers.get(() -> (GolemConfigStorage)TagCodec.fromTag((CompoundTag)tag, GolemConfigStorage.class, (Object)this.handler, f -> true));
        this.handler.init();
    }
}

